<script data-cfasync="false" type="text/javascript" src="{$systemUrl}assets/js/dataTables.bootstrap.js"></script>

<nav class="nav">
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=index" class="active"><i class="fa fa-clock"></i>Awaiting Approval</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=charged"><i class="fa fa-history"></i>Charged</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=open"><i class="fa fa-user"></i>Open</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=cron"><i class="fa fa-info-circle"></i>Cron info</a>
    <a href="addonmodules.php?module=GiantVoIPResellerBilling&action=free"><i class="fa fa-wrench"></i>Free Minutes</a>
</nav>

<div class="panel panel-default">
    <div class="panel-body">
        <table id="productTable" class="table table-striped table-bordered"
               style="border-collapse:collapse; width:100%;">
            <thead>
            <tr>
                <th>Tenant ID</th>
                <th>Calls Length (min)</th>
                <th>Calls Amount</th>
                <th>SMS Amount</th>
                <th>Date</th>
                <th>Amount (Calls)</th>
                <th>Amount (SMS)</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

{literal}
    <div id="editModal" class="modal fade" role="dialog">
        <form method="POST" id="editForm" action="addonmodules.php?module=GiantVoIPResellerBilling&action=approveBilling">
            <input id="editTenantId" type="hidden" name="tenantId"/>
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" style="display:inline-block;">Edit Billing</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <input type="text" name="description"
                                   class="form-control"
                                   id="description" aria-describedby="description"
                                   placeholder="Description">
                        </div>
                        <div class="form-group">
                            <label for="amount">Amount</label>
                            <input required type="text" name="amount"
                                   class="form-control"
                                   id="amount" aria-describedby="amount"
                                   placeholder="Amount">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Approve</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
{/literal}

<div id="approveModal" class="modal fade" role="dialog">
    <form method="POST" action="addonmodules.php?module=GiantVoIPResellerBilling&action=approveBilling">
        <input id="approveTenantId" type="hidden" name="tenantId"/>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" style="display:inline-block;">Approve Billing</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h2>Are you Sure?</h2>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Approve</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </form>
</div>

<div id="cancelModal" class="modal fade" role="dialog">
    <form method="POST" action="addonmodules.php?module=GiantVoIPResellerBilling&action=declineBilling">
        <input id="cancelTenantId" type="hidden" name="tenantId"/>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" style="display:inline-block;">Cancel Billing</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h2>Are you Sure?</h2>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Cancel</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </form>
</div>


<script>
    $(document).ready(function () {
        {literal}
        $('#editForm').submit(function (e) {
            let value = $('#amount').val();
            let regex = /^(?!^0\.00$)(([1-9][\d]{0,6})|([0]))\.[\d]{2}$/
            if (value !== '0') {
                if (!regex.test(value)) {
                    e.preventDefault();
                    alert('Invalid amount value');
                }
            }
        });
        {/literal}
    });

    function approveModal(tenant) {
        $('#approveTenantId').val(tenant);
    }

    function cancelModal(tenant) {
        $('#cancelTenantId').val(tenant);
    }

    function editModal(amount, tenant) {
        $('#amount').val(amount);
        $('#editTenantId').val(tenant);
    }


    $(document).ready(function () {
        $('#productTable').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": "addonmodules.php?module=GiantVoIPResellerBilling&action=getBillings",
            "searching": true,
            "columns": [
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                {
                    "data": "test",
                    "defaultContent": ""
                }
            ],
            "columnDefs": [
                {
                    "targets": [7],
                    'searchable': true,
                    'orderable': true,
                    'render': function (data, type, full) {
                        return `
                                        <button onclick="approveModal('{literal}${full["tenantId"]}{/literal}')" data-toggle="modal" data-target="#approveModal" type="button" class='btn btn-success'><i class='fa fa-check'></i></button>
                                        <button onclick="editModal({literal}${full[4]}, '${full["tenantId"]}{/literal}')" data-toggle="modal" data-target="#editModal" type="button" class='btn btn-primary'><i class='fa fa-edit'></i></button>
                                        <button onclick="cancelModal('{literal}${full["tenantId"]}{/literal}')" data-toggle="modal" data-target="#cancelModal" type="button" class='btn btn-danger'><i class='fa fa-times'></i></button>`
                    }
                }, {
                    "targets": [0],
                    'searchable': true,
                    'orderable': true,
                    'render': function (data, type, full) {
                        return `<a href='{$systemurl}clientsservices.php?userid={literal}${full.userId}{/literal}&id={literal}${full.hostingId}{/literal}'>{literal}${full[0]}{/literal}</a>`
                    }
                }
            ]
        })
    });


</script>


<style>
    .nav {
        padding: 10px;
    }

    .nav a {
        cursor: pointer;
        display: inline-block;
        text-align: center;
        width: 200px;
        padding: 10px;
        color: #337ab7;
        border-radius: 6px;
    }

    .nav a:hover {
        text-decoration: none;
    }

    .nav a i {
        font-size: 1.5rem;
        margin-right: 5px;
    }

    .nav a.active {
        background-color: #337ab7;
        color: white;
    }
</style>