<?php

namespace XeroPHP\Models\Accounting\TrackingCategory;

use XeroPHP\Remote;
class TrackingOption extends Remote\Model
{
    /**
     * The Xero identifier for a tracking optione.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a
     *
     * @property string TrackingOptionID
     */
    /**
     * The name of the tracking option e.g. Marketing, East (max length = 50)
     *
     * @property string Name
     */
    /**
     * The status of a tracking option
     *
     * @property string Status
     */
    /**
     * Get the resource uri of the class (Contacts) etc
     *
     * @return string
     */
    public static function getResourceURI()
    {
        return 'Options';
    }
    /**
     * Get the root node name.  Just the unqualified classname
     *
     * @return string
     */
    public static function getRootNodeName()
    {
        return 'Option';
    }
    /**
     * Get the guid property
     *
     * @return string
     */
    public static function getGUIDProperty()
    {
        return 'TrackingOptionID';
    }
    /**
     * Get the stem of the API (core.xro) etc
     *
     * @return string
     */
    public static function getAPIStem()
    {
        return Remote\URL::API_CORE;
    }
    /**
     * Get the supported methods
     */
    public static function getSupportedMethods()
    {
        return [Remote\Request::METHOD_POST, Remote\Request::METHOD_DELETE];
    }
    /**
     * Get the properties of the object.  Indexed by constants
     *  [0] - Mandatory
     *  [1] - Type
     *  [2] - PHP type
     *  [3] - Is an Array
     *  [4] - Saves directly
     *
     * @return array
     */
    public static function getProperties()
    {
        return ['TrackingOptionID' => [\false, self::PROPERTY_TYPE_STRING, null, \false, \false], 'Name' => [\false, self::PROPERTY_TYPE_STRING, null, \false, \false], 'Status' => [\false, self::PROPERTY_TYPE_STRING, null, \false, \false]];
    }
    public static function isPageable()
    {
        return \false;
    }
    /**
     * @return string
     */
    public function getTrackingOptionID()
    {
        return $this->_data['TrackingOptionID'];
    }
    /**
     * @param string $value
     * @return TrackingOption
     */
    public function setTrackingOptionID($value)
    {
        $this->propertyUpdated('TrackingOptionID', $value);
        $this->_data['TrackingOptionID'] = $value;
        return $this;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->_data['Name'];
    }
    /**
     * @param string $value
     * @return TrackingOption
     */
    public function setName($value)
    {
        $this->propertyUpdated('Name', $value);
        $this->_data['Name'] = $value;
        return $this;
    }
    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->_data['Status'];
    }
    /**
     * @param string $value
     * @return TrackingOption
     */
    public function setStatus($value)
    {
        $this->propertyUpdated('Status', $value);
        $this->_data['Status'] = $value;
        return $this;
    }
}
