<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Controller\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\RuntimeException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Article;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Category;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Factory\ClientAreaFactory;
use SupportPal\WhmcsIntegration\Helper\AuthenticatedUserHelper;
use SupportPal\WhmcsIntegration\Helper\CaptchaHelper;
use SupportPal\WhmcsIntegration\Helper\DateTimeFormatter;
use SupportPal\WhmcsIntegration\Helper\Paginator;
use SupportPal\WhmcsIntegration\Helper\StringHelper;
use SupportPal\WhmcsIntegration\Log\ExceptionLogger;
use SupportPal\WhmcsIntegration\Repository\Core\CoreSettingsRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\ArticleRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\CategoryRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\CommentRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\SelfServiceSettingsRepository;
use SupportPal\WhmcsIntegration\Repository\SelfService\TagRepository;
use SupportPal\WhmcsIntegration\Repository\UserRepository;
use SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository;
use SupportPal\WhmcsIntegration\Request\Request;
use SupportPal\WhmcsIntegration\Request\RequestParser;
use SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter;
use SupportPal\WhmcsIntegration\Service\Manager\Locale\LocaleManager;
use SupportPal\WhmcsIntegration\Service\Manager\SelfService\CommentManager;
use WHMCS\Application\Support\Facades\Lang;
use WHMCS\Application\Support\Facades\Menu;
use WHMCS\ClientArea;
use function htmlentities;
class AnnouncementsController extends \SupportPal\WhmcsIntegration\Controller\SelfService\BaseSelfServiceController
{
    protected const TYPE = 'announcements';
    protected const DEFAULT_PAGE_TITLE = 'announcementstitle';
    /** @var RequestParser */
    private $requestParser;
    /**
     * AnnouncementsController constructor.
     * @param DateTimeFormatter $dateTimeFormatter
     * @param ModelToArrayConverter $modelToArrayConverter
     * @param ArticleRepository $articleRepository
     * @param SelfServiceSettingsRepository $settingsRepository
     * @param CategoryRepository $categoryRepository
     * @param TagRepository $tagRepository
     * @param CoreSettingsRepository $coreSettingsRepository
     * @param CommentRepository $commentRepository
     * @param CommentManager $commentManager
     * @param CaptchaHelper $captchaHelper
     * @param StringHelper $stringHelper
     * @param AuthenticatedUserHelper $authenticatedUserHelper
     * @param UserRepository $userRepository
     * @param ModSupportPalRepository $modSupportPalRepository
     * @param ArticleTypeRepository $articleTypeRepository
     * @param LocaleManager $localeManager
     * @param RequestParser $requestParser
     * @param ClientAreaFactory $clientAreaFactory
     * @param Paginator $paginator
     * @param ExceptionLogger $exceptionLogger
     */
    public function __construct(\SupportPal\WhmcsIntegration\Helper\DateTimeFormatter $dateTimeFormatter, \SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter $modelToArrayConverter, \SupportPal\WhmcsIntegration\Repository\SelfService\ArticleRepository $articleRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\SelfServiceSettingsRepository $settingsRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\CategoryRepository $categoryRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\TagRepository $tagRepository, \SupportPal\WhmcsIntegration\Repository\Core\CoreSettingsRepository $coreSettingsRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\CommentRepository $commentRepository, \SupportPal\WhmcsIntegration\Service\Manager\SelfService\CommentManager $commentManager, \SupportPal\WhmcsIntegration\Helper\CaptchaHelper $captchaHelper, \SupportPal\WhmcsIntegration\Helper\StringHelper $stringHelper, \SupportPal\WhmcsIntegration\Helper\AuthenticatedUserHelper $authenticatedUserHelper, \SupportPal\WhmcsIntegration\Repository\UserRepository $userRepository, \SupportPal\WhmcsIntegration\Repository\Whmcs\ModSupportPalRepository $modSupportPalRepository, \SupportPal\WhmcsIntegration\Repository\SelfService\ArticleTypeRepository $articleTypeRepository, \SupportPal\WhmcsIntegration\Service\Manager\Locale\LocaleManager $localeManager, \SupportPal\WhmcsIntegration\Request\RequestParser $requestParser, \SupportPal\WhmcsIntegration\Factory\ClientAreaFactory $clientAreaFactory, \SupportPal\WhmcsIntegration\Helper\Paginator $paginator, \SupportPal\WhmcsIntegration\Log\ExceptionLogger $exceptionLogger)
    {
        parent::__construct($dateTimeFormatter, $modelToArrayConverter, $articleRepository, $settingsRepository, $categoryRepository, $tagRepository, $coreSettingsRepository, $commentRepository, $commentManager, $captchaHelper, $stringHelper, $authenticatedUserHelper, $userRepository, $modSupportPalRepository, $articleTypeRepository, $localeManager, $clientAreaFactory, $paginator, $exceptionLogger);
        $this->requestParser = $requestParser;
    }
    /**
     * @param string|null $search
     * @param int|null $tagId
     * @param int|null $categoryId
     * @param int $currentPage
     * @return void
     */
    public function showFilteredArticles(?string $search, ?int $tagId, ?int $categoryId, int $currentPage) : void
    {
        $clientArea = $this->prologue($this->getAllTemplatePath());
        try {
            $this->setTypeId();
            $this->showFiltered($clientArea, $categoryId, $currentPage, $search, $tagId);
        } catch (\SupportPal\WhmcsIntegration\Exception\InvalidApiResponse|\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\Exception|\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\RuntimeException $exception) {
            $this->exceptionLogger->log($exception, __FUNCTION__);
            $this->showNotFoundPage($clientArea, 'articles');
        }
    }
    public function showAll(\SupportPal\WhmcsIntegration\Request\Request $request) : void
    {
        $categoryId = $this->requestParser->parseIntOrNull($request, 'category');
        $tagId = $this->requestParser->parseIntOrNull($request, 'tag');
        $page = $this->paginator->current($request);
        $search = $request->get('search', null);
        $this->showFilteredArticles($search, $tagId, $categoryId, $page);
    }
    /**
     * @param mixed[] $articleData
     */
    protected function showSideMenu(array $articleData) : void
    {
        if (!isset($articleData['categories'])) {
            return;
        }
        // Show the sidebar with announcements active
        $secondarySidebar = \WHMCS\Application\Support\Facades\Menu::secondarySidebar('announcementList');
        // Add a new menu above for categories
        $secondarySidebar->addChild('categories', array('label' => \WHMCS\Application\Support\Facades\Lang::trans('knowledgebasecategories'), 'uri' => '#', 'icon' => 'fa-folder-open'));
        // Retrieve the panel we just created
        $menuPanel = $secondarySidebar->getChild('categories');
        if ($menuPanel === null) {
            return;
        }
        // Add an all announcements link
        $menuPanel->addChild('category-0', ['uri' => 'announcements.php', 'label' => $this->locale['announcement_all'], 'class' => 'active']);
        // Add each category link
        foreach ($articleData['categories'] as $category) {
            $menuPanel->addChild('category-' . \htmlentities($category['name']), ['uri' => 'announcements.php?category=' . $category['id'], 'label' => \htmlentities($category['name'])]);
        }
    }
    /**
     * @return string
     */
    protected function getArticleTemplatePath() : string
    {
        return '../supportpal/announcement_view';
    }
    /**
     * @return string
     */
    protected function getAllTemplatePath() : string
    {
        return '../supportpal/announcements';
    }
    /**
     * @return string
     */
    protected function getFilteredTemplate() : string
    {
        return '../supportpal/announcements';
    }
    /**
     * @param ClientArea $clientArea
     * @param int|null $categoryId
     * @param int $currentPage
     * @param string|null $search
     * @param int|null $tagId
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    private function showFiltered(\WHMCS\ClientArea $clientArea, ?int $categoryId, int $currentPage, ?string $search, ?int $tagId) : void
    {
        if ($this->typeId === null) {
            $this->showNotFoundPage($clientArea, 'articles');
            return;
        }
        $data = ['type_id' => $this->getTypeId(), 'public' => 1, 'parent_public' => 1, 'order_column' => 'name'];
        // Get all categories
        $categoriesCollection = $this->categoryRepository->findBy($data);
        $categoryData = [];
        /** @var Category $category */
        foreach ($categoriesCollection->getModels() as $category) {
            $categoryData[] = $this->modelToArrayConverter->convertOne($category);
            if ($category->getId() !== $categoryId) {
                continue;
            }
            $pageTitle = $category->getName();
            $clientArea->addToBreadCrumb('', \htmlentities($pageTitle));
            $clientArea->assign('category', $this->stringHelper->getUrlSlug($pageTitle));
        }
        $articleFilters = ['type_id' => $this->getTypeId(), 'include_subcategories' => 1, 'published' => 1, 'protected' => $clientArea->isLoggedIn() ? null : 0, 'start' => $this->paginator->start($currentPage), 'limit' => $this->paginator->limit(), 'order_column' => 'published_at', 'order_direction' => 'desc'];
        if ($search !== null) {
            $articlesCollection = $this->getArticlesByTerm($clientArea, $search, $articleFilters);
        } else {
            $articlesCollection = $this->getArticlesByTagAndCategory($categoryId, $articleFilters, $tagId);
        }
        /** @var Article[] $filteredArticles */
        $filteredArticles = $articlesCollection->filter($this->belongsToAPublicCategory())->getModels();
        $articleData = $this->createFinalDataArray($filteredArticles, $categoryData, 'articles');
        if ($tagId !== null) {
            $pageTitle = $this->setTag($tagId, $clientArea);
        }
        $this->setupFilteredData($articlesCollection, $clientArea, $currentPage, $articleData, $pageTitle ?? \WHMCS\Application\Support\Facades\Lang::trans(static::DEFAULT_PAGE_TITLE));
    }
}
