<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use SupportPal\WhmcsIntegration\Factory\CaptchaBuilderFactory;
/**
 * Gregwar captcha wrapper
 *
 * Class CaptchaHelper
 * @package SupportPal\WhmcsIntegration\Helper
 */
class CaptchaHelper
{
    /** @var SessionHelper */
    private $sessionHelper;
    /** @var CaptchaBuilderFactory */
    private $captchaBuilderFactory;
    /**
     * CaptchaHelper constructor.
     * @param SessionHelper $sessionHelper
     * @param CaptchaBuilderFactory $captchaBuilderFactory
     */
    public function __construct(\SupportPal\WhmcsIntegration\Helper\SessionHelper $sessionHelper, \SupportPal\WhmcsIntegration\Factory\CaptchaBuilderFactory $captchaBuilderFactory)
    {
        $this->sessionHelper = $sessionHelper;
        $this->captchaBuilderFactory = $captchaBuilderFactory;
    }
    /**
     * Build the SupportPal captcha output.
     *
     * @return string
     */
    public function buildHtml() : string
    {
        $builder = $this->captchaBuilderFactory->create()->build();
        $this->sessionHelper->setCaptchaPhrase($builder->getPhrase());
        return '<img src="' . $builder->inline() . '" /><br />' . '<input type="text" name="captcha" class="form-control" style="margin-top: 10px; width: 150px;" />';
    }
    /**
     * Build the SupportPal captcha output.
     *
     * @param string $input
     * @return bool
     */
    public function verify(string $input) : bool
    {
        $builder = $this->captchaBuilderFactory->create($this->sessionHelper->getCaptchaPhrase());
        return $builder->testPhrase($input);
    }
}
