<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use function date;
/**
 * Class DateTimeFormatter
 * @package SupportPal\WhmcsIntegration\Helper
 */
class DateTimeFormatter
{
    /**
     * @param string $dateFormat
     * @param string $timeFormat
     * @param int $timestamp
     * @return string
     */
    public function format(string $dateFormat, string $timeFormat, int $timestamp) : string
    {
        return \date($dateFormat . ' ' . $timeFormat, $timestamp);
    }
}
