<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Helper;

use SupportPal\WhmcsIntegration\Request\Request;
use function ceil;
class Paginator
{
    /** @var int */
    private $perPage;
    public function __construct(int $perPage = 10)
    {
        $this->perPage = $perPage;
    }
    public function current(\SupportPal\WhmcsIntegration\Request\Request $request) : int
    {
        $page = (int) $request->get('page', 1);
        return $page > 0 ? $page : 1;
    }
    public function start(int $currentPage) : int
    {
        $start = ($currentPage - 1) * $this->perPage + 1;
        if ($start <= 0) {
            return 0;
        }
        return $start;
    }
    public function limit() : int
    {
        return $this->perPage;
    }
    public function total(int $count) : int
    {
        $total = \ceil($count / $this->perPage);
        return (int) ($total > 0 ? $total : 1);
    }
    public function setPerPage(int $perPage) : self
    {
        $this->perPage = $perPage;
        return $this;
    }
}
