<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class CustomFieldRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
class CustomFieldRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @param mixed[] $parameters
     * @return Collection
     * @throws InvalidArgumentException
     * @throws InvalidApiResponse
     */
    public function findBy(array $parameters) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($parameters) {
            return $this->getApi()->getCustomFields($parameters);
        }, 'getCustomFields');
    }
}
