<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class StatusRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
class StatusRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @param int $id
     * @return Status
     * @throws InvalidApiResponse
     */
    public function find(int $id) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket\Status
    {
        return $this->callAndMapException(function () use($id) {
            return $this->getApi()->getStatus($id);
        }, 'getStatus');
    }
    /**
     * @param mixed[] $data
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findBy(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($data) {
            return $this->getApi()->getStatuses($data);
        }, 'getStatuses');
    }
}
