<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\Ticket;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings;
/**
 * Class TicketSettingsRepository
 * @package SupportPal\WhmcsIntegration\Repository\Ticket
 */
class TicketSettingsRepository extends \SupportPal\WhmcsIntegration\Repository\Ticket\BaseTicketRepository
{
    /**
     * @return Settings
     * @throws Exception
     */
    public function get() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Shared\Settings
    {
        return $this->callAndMapException(function () {
            return $this->getApi()->getSettings();
        }, 'getSettings');
    }
}
