<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\User;

use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi;
use SupportPal\WhmcsIntegration\Repository\BaseRepository;
/**
 * Class BaseUserRepository
 * @package SupportPal\WhmcsIntegration\Repository\User
 */
abstract class BaseUserRepository extends \SupportPal\WhmcsIntegration\Repository\BaseRepository
{
    /**
     * @return UserApi
     * @throws Exception
     */
    protected function getApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi
    {
        return $this->getApiClientWrapper()->getSupportPal()->getUserApi();
    }
}
