<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository\User;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
/**
 * Class UserCustomFieldsRepository
 * @package SupportPal\WhmcsIntegration\Repository\User
 */
class UserCustomFieldsRepository extends \SupportPal\WhmcsIntegration\Repository\User\BaseUserRepository
{
    /**
     * @param mixed[] $parameters
     * @return Collection
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function findBy(array $parameters) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return $this->callAndMapException(function () use($parameters) {
            return $this->getApi()->getCustomFields($parameters);
        }, 'getCustomFields');
    }
}
