<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Repository;

use Closure;
use Exception;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User;
use SupportPal\WhmcsIntegration\Exception\InvalidApiResponse;
use SupportPal\WhmcsIntegration\Log\ExceptionLogger;
use SupportPal\WhmcsIntegration\Log\RequestLogger;
use SupportPal\WhmcsIntegration\Repository\Whmcs\ClientRepository;
use SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter;
use SupportPal\WhmcsIntegration\SupportPalApiClientWrapper;
use function strtolower;
class UserRepository extends \SupportPal\WhmcsIntegration\Repository\BaseRepository
{
    /** @var ClientRepository */
    private $clientRepository;
    /** @var ModelToArrayConverter */
    private $modelToArrayConverter;
    public function __construct(\SupportPal\WhmcsIntegration\SupportPalApiClientWrapper $apiClient, \SupportPal\WhmcsIntegration\Repository\Whmcs\ClientRepository $clientRepository, \SupportPal\WhmcsIntegration\Service\Converter\ModelToArrayConverter $modelToArrayConverter, \SupportPal\WhmcsIntegration\Log\RequestLogger $logger, \SupportPal\WhmcsIntegration\Log\ExceptionLogger $exceptionLogger)
    {
        parent::__construct($apiClient, $logger, $exceptionLogger);
        $this->clientRepository = $clientRepository;
        $this->modelToArrayConverter = $modelToArrayConverter;
    }
    /**
     * Get logged in user's help desk account
     *
     * @param int|null $id The user ID
     * @param string|null $email Alternatively provide the email directly
     * @return mixed[]|null
     * @throws InvalidApiResponse
     * @throws InvalidArgumentException
     */
    public function getHelpdeskAccount(?int $id = null, ?string $email = null) : ?array
    {
        if (!isset($email) && $id !== null) {
            // Get WHMCS user account
            $user = $this->clientRepository->getOneById($id);
            if ($user === null) {
                return null;
            }
            $email = $user->email;
        }
        if ($email !== null) {
            // Check if user exists
            $data = ['email' => \strtolower($email)];
            /** @var User|null $user */
            $user = $this->callAndMapException(function () use($data) {
                return $this->getApi()->getUsers($data);
            }, 'getUsers')->filter($this->filterByEmail($email))->first();
            return $user !== null ? $this->modelToArrayConverter->convertOne($user) : null;
        }
        return null;
    }
    /**
     * @return UserApi
     * @throws Exception
     */
    public function getApi() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\UserApi
    {
        return $this->getApiClientWrapper()->getSupportPal()->getUserApi();
    }
    /**
     * @param string $email
     * @return Closure
     */
    protected function filterByEmail(string $email) : \Closure
    {
        return function (\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\User\User $user) use($email) {
            if ($user->getEmail() === null) {
                return \false;
            }
            return \strtolower($user->getEmail()) === \strtolower($email);
        };
    }
}
