<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Request;

use function current;
use function explode;
use function is_numeric;
class RequestParser
{
    /**
     * @param Request $request
     * @param string $attribute
     * @return string|null
     */
    public function parse(\SupportPal\WhmcsIntegration\Request\Request $request, string $attribute) : ?string
    {
        $value = $request->get($attribute, null);
        if ($value === null) {
            return null;
        }
        return \current(\explode('-', $value));
    }
    /**
     * @param Request $request
     * @param string $attribute
     * @return int|null
     */
    public function parseIntOrNull(\SupportPal\WhmcsIntegration\Request\Request $request, string $attribute) : ?int
    {
        $value = $this->parse($request, $attribute);
        return \is_numeric($value) ? (int) $value : null;
    }
}
