<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Service\Manager\Locale;

use DirectoryIterator;
use function array_merge;
use function in_array;
use function is_array;
use function is_string;
class LocaleManager
{
    const LANGUAGE_DIR = __DIR__ . '/../../../Lang/';
    /** @var string[] */
    private $defaultLanguageArray;
    public function __construct(string $defaultLangFile = 'English.php')
    {
        require self::LANGUAGE_DIR . $defaultLangFile;
        if (!isset($_LANG)) {
            return;
        }
        $this->defaultLanguageArray = $_LANG;
        unset($_LANG);
    }
    /**
     * @param string $locale
     * @return string[]
     */
    public function getLocale(string $locale) : array
    {
        $directoryIterator = new \DirectoryIterator(self::LANGUAGE_DIR);
        foreach ($directoryIterator as $languageFile) {
            if (!$languageFile->isFile()) {
                continue;
            }
            require $languageFile->getPathname();
            if (isset($_LANG) && $this->supports($locale, $_LANG['locale'])) {
                $currentFileLang = $_LANG;
                unset($_LANG);
                return \array_merge($this->defaultLanguageArray, $currentFileLang);
            }
        }
        return $this->defaultLanguageArray;
    }
    /**
     * @param string $locale
     * @param string|string[] $fileLocale
     * @return bool
     */
    private function supports(string $locale, $fileLocale) : bool
    {
        return \is_string($fileLocale) && $locale === $fileLocale || \is_array($fileLocale) && \in_array($locale, $fileLocale);
    }
}
