<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry;
use SupportPal\WhmcsIntegration\Vendor\League\Flysystem\AdapterInterface;
use SupportPal\WhmcsIntegration\Vendor\League\Flysystem\Filesystem;
use SupportPal\WhmcsIntegration\Vendor\League\Flysystem\FileNotFoundException;
class FlysystemStorage implements \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\CacheStorageInterface
{
    /**
     * @var Filesystem
     */
    protected $filesystem;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\League\Flysystem\AdapterInterface $adapter)
    {
        $this->filesystem = new \SupportPal\WhmcsIntegration\Vendor\League\Flysystem\Filesystem($adapter);
    }
    /**
     * @inheritdoc
     */
    public function fetch($key)
    {
        if ($this->filesystem->has($key)) {
            // The file exist, read it!
            $data = @\unserialize($this->filesystem->read($key));
            if ($data instanceof \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry) {
                return $data;
            }
        }
        return;
    }
    /**
     * @inheritdoc
     */
    public function save($key, \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\CacheEntry $data)
    {
        return $this->filesystem->put($key, \serialize($data));
    }
    /**
     * {@inheritdoc}
     */
    public function delete($key)
    {
        try {
            return $this->filesystem->delete($key);
        } catch (\SupportPal\WhmcsIntegration\Vendor\League\Flysystem\FileNotFoundException $ex) {
            return \true;
        }
    }
}
