<?php

namespace SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\KeyValueHttpHeader;
use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\CacheStorageInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
/**
 * This strategy represents a "public" or "shared" HTTP client.
 * You can share the storage between applications.
 *
 * For example, a response with cache-control header "private, max-age=60"
 * will be NOT cached by this strategy.
 *
 * The rules applied are from RFC 7234.
 *
 * @see https://tools.ietf.org/html/rfc7234
 */
class PublicCacheStrategy extends \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\PrivateCacheStrategy
{
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Storage\CacheStorageInterface $cache = null)
    {
        parent::__construct($cache);
        \array_unshift($this->ageKey, 's-maxage');
    }
    /**
     * {@inheritdoc}
     */
    protected function getCacheObject(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response)
    {
        $cacheControl = new \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\KeyValueHttpHeader($response->getHeader('Cache-Control'));
        if ($cacheControl->has('private')) {
            return;
        }
        return parent::getCacheObject($request, $response);
    }
}
