<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @link      http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags;

use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Description;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\DescriptionFactory;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\TypeResolver;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Context as TypeContext;
use SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Utils;
use SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert;
use function array_shift;
use function array_unshift;
use function implode;
use function strpos;
use function substr;
use const PREG_SPLIT_DELIM_CAPTURE;
/**
 * Reflection class for a {@}property-read tag in a Docblock.
 */
final class PropertyRead extends \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\TagWithType implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\Factory\StaticMethod
{
    /** @var string|null */
    protected $variableName;
    public function __construct(?string $variableName, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Type $type = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Description $description = null)
    {
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::string($variableName);
        $this->name = 'property-read';
        $this->variableName = $variableName;
        $this->type = $type;
        $this->description = $description;
    }
    public static function create(string $body, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\TypeResolver $typeResolver = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\DescriptionFactory $descriptionFactory = null, ?\SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Types\Context $context = null) : self
    {
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::stringNotEmpty($body);
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::notNull($typeResolver);
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::notNull($descriptionFactory);
        [$firstPart, $body] = self::extractTypeFromBody($body);
        $type = null;
        $parts = \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\Utils::pregSplit('/(\\s+)/Su', $body, 2, \PREG_SPLIT_DELIM_CAPTURE);
        $variableName = '';
        // if the first item that is encountered is not a variable; it is a type
        if ($firstPart && $firstPart[0] !== '$') {
            $type = $typeResolver->resolve($firstPart, $context);
        } else {
            // first part is not a type; we should prepend it to the parts array for further processing
            \array_unshift($parts, $firstPart);
        }
        // if the next item starts with a $ it must be the variable name
        if (isset($parts[0]) && \strpos($parts[0], '$') === 0) {
            $variableName = \array_shift($parts);
            if ($type) {
                \array_shift($parts);
            }
            \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::notNull($variableName);
            $variableName = \substr($variableName, 1);
        }
        $description = $descriptionFactory->create(\implode('', $parts), $context);
        return new static($variableName, $type, $description);
    }
    /**
     * Returns the variable's name.
     */
    public function getVariableName() : ?string
    {
        return $this->variableName;
    }
    /**
     * Returns a string representation for this tag.
     */
    public function __toString() : string
    {
        if ($this->description) {
            $description = $this->description->render();
        } else {
            $description = '';
        }
        if ($this->variableName) {
            $variableName = '$' . $this->variableName;
        } else {
            $variableName = '';
        }
        $type = (string) $this->type;
        return $type . ($variableName !== '' ? ($type !== '' ? ' ' : '') . $variableName : '') . ($description !== '' ? ($type !== '' || $variableName !== '' ? ' ' : '') . $description : '');
    }
}
