<?php

declare (strict_types=1);
/**
 * This file is part of phpDocumentor.
 *
 *  For the full copyright and license information, please view the LICENSE
 *  file that was distributed with this source code.
 *
 * @link http://phpdoc.org
 */
namespace SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\Reference;

use SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert;
/**
 * Url reference used by {@see \phpDocumentor\Reflection\DocBlock\Tags\See}
 */
final class Url implements \SupportPal\WhmcsIntegration\Vendor\phpDocumentor\Reflection\DocBlock\Tags\Reference\Reference
{
    /** @var string */
    private $uri;
    public function __construct(string $uri)
    {
        \SupportPal\WhmcsIntegration\Vendor\Webmozart\Assert\Assert::stringNotEmpty($uri);
        $this->uri = $uri;
    }
    public function __toString() : string
    {
        return $this->uri;
    }
}
