<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\CoreApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\UserApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection\CollectionFactory;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelCollectionFactory;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface;
abstract class Api
{
    use ApiAware;
    /** @var UserApiClient|SelfServiceApiClient|TicketApiClient|CoreApiClient|ApiClient */
    protected $apiClient;
    /** @var ModelToArrayConverter */
    private $modelToArrayConverter;
    /** @var string */
    private $formatType;
    /** @var ModelCollectionFactory */
    private $modelCollectionFactory;
    /** @var DecoderInterface */
    private $decoder;
    /** @var CollectionFactory */
    private $collectionFactory;
    public function __construct(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter $modelToArrayConverter, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelCollectionFactory $modelCollectionFactory, string $formatType, \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface $decoder, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection\CollectionFactory $collectionFactory, \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient $apiClient)
    {
        $this->modelToArrayConverter = $modelToArrayConverter;
        $this->formatType = $formatType;
        $this->modelCollectionFactory = $modelCollectionFactory;
        $this->decoder = $decoder;
        $this->collectionFactory = $collectionFactory;
        $this->apiClient = $apiClient;
    }
    /**
     * @inheritDoc
     */
    protected function getModelToArrayConverter() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter
    {
        return $this->modelToArrayConverter;
    }
    /**
     * @inheritDoc
     */
    protected function getFormatType() : string
    {
        return $this->formatType;
    }
    /**
     * @inheritDoc
     */
    protected function getModelCollectionFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelCollectionFactory
    {
        return $this->modelCollectionFactory;
    }
    /**
     * @inheritDoc
     */
    protected function getDecoder() : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface
    {
        return $this->decoder;
    }
    /**
     * @param ResponseInterface $response
     * @return array<mixed>
     */
    protected function decodeBody(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response) : array
    {
        /** @var array<mixed> $body */
        $body = $this->getDecoder()->decode((string) $response->getBody(), $this->getFormatType());
        return $body;
    }
    /**
     * @return CollectionFactory
     */
    protected function getCollectionFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection\CollectionFactory
    {
        return $this->collectionFactory;
    }
}
