<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection\CollectionFactory;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelCollectionFactory;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface;
/**
 * Contains all required method definitions and attribute dependencies in Api traits
 * Trait ApiAware
 * @package SupportPal\ApiClient\Api
 */
trait ApiAware
{
    /**
     * @return ModelCollectionFactory
     */
    protected abstract function getModelCollectionFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\ModelCollectionFactory;
    /**
     * @return DecoderInterface
     */
    protected abstract function getDecoder() : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Encoder\DecoderInterface;
    /**
     * @return string
     */
    protected abstract function getFormatType() : string;
    /**
     * @return ModelToArrayConverter
     */
    protected abstract function getModelToArrayConverter() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Converter\ModelToArrayConverter;
    /**
     * @param ResponseInterface $response
     * @return array<mixed>
     */
    protected abstract function decodeBody(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response) : array;
    /**
     * @return CollectionFactory
     */
    protected abstract function getCollectionFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection\CollectionFactory;
}
