<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag as SelfServiceTagAlias;
use function array_map;
/**
 * Trait TagApis, includes all related ApiCalls pre and post processing to Tags
 * @package SupportPal\ApiClient\Api\SelfService
 */
trait TagApis
{
    use ApiAware;
    /**
     * @param int $tagId
     * @return SelfServiceTagAlias
     * @throws HttpResponseException
     */
    public function getTag(int $tagId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag
    {
        $response = $this->getApiClient()->getTag($tagId);
        return $this->createTag($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException|InvalidArgumentException
     */
    public function getTags(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getTags($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createTag'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param array<mixed> $data
     * @return SelfServiceTagAlias
     */
    private function createTag(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag
    {
        /** @var SelfServiceTagAlias $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Tag::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
}
