<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type;
use function array_map;
/**
 * Trait TypeApis, includes all related ApiCalls pre and post processing to selfservice types
 * @package SupportPal\ApiClient\Api\SelfService
 */
trait TypeApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getTypes(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getTypes($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createType'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $typeId
     * @return Type
     * @throws HttpResponseException
     */
    public function getType(int $typeId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type
    {
        $response = $this->getApiClient()->getType($typeId);
        return $this->createType($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Type
     */
    private function createType(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type
    {
        /** @var Type $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService\Type::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfServiceApiClient;
}
