<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Api\ApiAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department;
use function array_map;
/**
 * Trait DepartmentApis, includes all related apis to departments
 * @package SupportPal\ApiClient\Api\Ticket
 */
trait DepartmentApis
{
    use ApiAware;
    /**
     * @param array<mixed> $queryParameters
     * @return Collection
     * @throws HttpResponseException
     * @throws InvalidArgumentException
     */
    public function getDepartments(array $queryParameters = []) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        $response = $this->getApiClient()->getDepartments($queryParameters);
        $body = $this->decodeBody($response);
        $models = \array_map([$this, 'createDepartment'], $body['data']);
        return $this->getCollectionFactory()->create($body['count'], $models);
    }
    /**
     * @param int $departmentId
     * @return Department
     * @throws HttpResponseException
     */
    public function getDepartment(int $departmentId) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department
    {
        $response = $this->getApiClient()->getDepartment($departmentId);
        return $this->createDepartment($this->decodeBody($response)['data']);
    }
    /**
     * @param array<mixed> $data
     * @return Department
     */
    private function createDepartment(array $data) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department
    {
        /** @var Department $model */
        $model = $this->getModelCollectionFactory()->create(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department::class, $data);
        return $model;
    }
    protected abstract function getApiClient() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\TicketApiClient;
}
