<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Client\ClientInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\RequestFactory;
/**
 * Contains all required method definitions and attribute dependencies in ApiClient traits
 * Trait ApiClientAware
 * @package SupportPal\ApiClient\ApiClient
 */
trait ApiClientAware
{
    /**
     * @return ClientInterface
     */
    protected abstract function getHttpClient() : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Client\ClientInterface;
    /**
     * @return RequestFactory
     */
    protected abstract function getRequestFactory() : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\RequestFactory;
    /**
     * @param RequestInterface $request
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public abstract function sendRequest(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
    /**
     * This method asserts that the request returned a successful response
     * @param RequestInterface $request
     * @param ResponseInterface $response
     * @throws HttpResponseException
     */
    protected abstract function assertRequestSuccessful(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request, \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface $response) : void;
    /**
     * @param string $endpoint
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    protected abstract function prepareAndSendGetRequest(string $endpoint, array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
    /**
     * @param RequestInterface $request
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    protected abstract function sendDownloadRequest(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
}
