<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\Core;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\ApiClientAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
trait BrandApis
{
    use ApiClientAware;
    /**
     * @param int $brandId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getBrand(int $brandId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::CORE_BRAND . '/' . $brandId, []);
    }
    /**
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getBrands(array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::CORE_BRAND, $queryParameters);
    }
}
