<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\SelfService;

use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\ApiClient\ApiClientAware;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\HttpResponseException;
/**
 * Trait CommentApis, includes all api calls related to comments
 * @package SupportPal\ApiClient\ApiClient\SelfService
 */
trait CommentApis
{
    use ApiClientAware;
    /**
     *
     * This method posts a self service comment
     * @param array<mixed> $body
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function postComment(array $body) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        $request = $this->getRequestFactory()->create('POST', \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_COMMENT, [], $body);
        return $this->sendRequest($request);
    }
    /**
     * @param array<mixed> $queryParameters
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getComments(array $queryParameters) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_COMMENT, $queryParameters);
    }
    /**
     * @param int $commentId
     * @return ResponseInterface
     * @throws HttpResponseException
     */
    public function getComment(int $commentId) : \SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\ResponseInterface
    {
        return $this->prepareAndSendGetRequest(\SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Dictionary\ApiDictionary::SELF_SERVICE_COMMENT . '/' . $commentId, []);
    }
}
