<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Cache;

use SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate\RequestMatcherInterface;
use SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface;
use function strpos;
class CacheableRequestMatcher implements \SupportPal\WhmcsIntegration\Vendor\Kevinrob\GuzzleCache\Strategy\Delegate\RequestMatcherInterface
{
    /** @var array<int, string> */
    private $cachableApis;
    /**
     * CacheableRequestMatcher constructor.
     * @param array<int, string> $cachableApis
     */
    public function __construct(array $cachableApis)
    {
        $this->cachableApis = $cachableApis;
    }
    /**
     * @inheritDoc
     */
    public function matches(\SupportPal\WhmcsIntegration\Vendor\Psr\Http\Message\RequestInterface $request)
    {
        foreach ($this->cachableApis as $path) {
            if (\strpos($request->getUri()->getPath(), $path) !== \false && $request->getMethod() === 'GET') {
                return \true;
            }
        }
        return \false;
    }
}
