<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Factory\Collection;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Model;
/**
 * This class handles the creation of Collection datatype instance
 * Class CollectionFactory
 * @package SupportPal\ApiClient\Factory\Collection
 */
class CollectionFactory
{
    /**
     * @param int $count
     * @param Model[] $models
     * @return Collection
     * @throws InvalidArgumentException
     */
    public function create(int $count, array $models) : \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection
    {
        return new \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Collection\Collection($count, $models);
    }
}
