<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\SelfService;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseTranslation;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class TypeTranslation extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseTranslation
{
    /**
     * @var int
     * @SerializedName("id")
     */
    private $id;
    /**
     * @var string
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var int
     * @SerializedName("type_id")
     */
    private $typeId;
    /**
     * @var string
     * @SerializedName("description")
     */
    private $description;
    /**
     * @var string|null
     * @SerializedName("slug")
     */
    private $slug;
    /**
     * @return int
     */
    public function getId() : int
    {
        return $this->id;
    }
    /**
     * @param int $id
     * @return $this
     */
    public function setId(int $id) : self
    {
        $this->id = $id;
        return $this;
    }
    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return int
     */
    public function getTypeId() : int
    {
        return $this->typeId;
    }
    /**
     * @param int $typeId
     * @return self
     */
    public function setTypeId(int $typeId) : self
    {
        $this->typeId = $typeId;
        return $this;
    }
    /**
     * @return string
     */
    public function getDescription() : string
    {
        return $this->description;
    }
    /**
     * @param string $description
     * @return self
     */
    public function setDescription(string $description) : self
    {
        $this->description = $description;
        return $this;
    }
    /**
     * @return string|null
     */
    public function getSlug() : ?string
    {
        return $this->slug;
    }
    /**
     * @param string|null $slug
     * @return self
     */
    public function setSlug(?string $slug) : self
    {
        $this->slug = $slug;
        return $this;
    }
}
