<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel;
use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Department\Department;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class Priority extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel
{
    /**
     * @var int
     * @SerializedName("id")
     */
    private $id;
    /**
     * @var string
     * @SerializedName("colour")
     */
    private $colour;
    /**
     * @var int
     * @SerializedName("updated_at")
     */
    private $updatedAt;
    /**
     * @var string
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var int|null
     * @SerializedName("order")
     */
    private $order;
    /**
     * @var int
     * @SerializedName("created_at")
     */
    private $createdAt;
    /**
     * @var string
     * @SerializedName("icon")
     */
    private $icon;
    /**
     * @var string
     * @SerializedName("icon_without_tooltip")
     */
    private $iconWithoutTooltip;
    /** @var Department[]|null */
    private $departments;
    /**
     * @var PriorityTranslation[]|null
     * @SerializedName("translations")
     */
    private $translations;
    /**
     * @return int
     */
    public function getId() : int
    {
        return $this->id;
    }
    /**
     * @param int $id
     * @return self
     */
    public function setId(int $id) : self
    {
        $this->id = $id;
        return $this;
    }
    /**
     * @return string
     */
    public function getColour() : string
    {
        return $this->colour;
    }
    /**
     * @param string $colour
     * @return self
     */
    public function setColour(string $colour) : self
    {
        $this->colour = $colour;
        return $this;
    }
    /**
     * @return int
     */
    public function getUpdatedAt() : int
    {
        return $this->updatedAt;
    }
    /**
     * @param int $updatedAt
     * @return self
     */
    public function setUpdatedAt(int $updatedAt) : self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }
    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getOrder() : ?int
    {
        return $this->order;
    }
    /**
     * @param int|null $order
     * @return self
     */
    public function setOrder(?int $order) : self
    {
        $this->order = $order;
        return $this;
    }
    /**
     * @return int
     */
    public function getCreatedAt() : int
    {
        return $this->createdAt;
    }
    /**
     * @param int $createdAt
     * @return self
     */
    public function setCreatedAt(int $createdAt) : self
    {
        $this->createdAt = $createdAt;
        return $this;
    }
    /**
     * @return string
     */
    public function getIcon() : string
    {
        return $this->icon;
    }
    /**
     * @param string $icon
     * @return self
     */
    public function setIcon(string $icon) : self
    {
        $this->icon = $icon;
        return $this;
    }
    /**
     * @return string
     */
    public function getIconWithoutTooltip() : string
    {
        return $this->iconWithoutTooltip;
    }
    /**
     * @param string $iconWithoutTooltip
     * @return self
     */
    public function setIconWithoutTooltip(string $iconWithoutTooltip) : self
    {
        $this->iconWithoutTooltip = $iconWithoutTooltip;
        return $this;
    }
    /**
     * @return Department[]|null
     */
    public function getDepartments() : ?array
    {
        return $this->departments;
    }
    /**
     * @param Department[]|null $departments
     * @return self
     */
    public function setDepartments(?array $departments) : self
    {
        $this->departments = $departments;
        return $this;
    }
    /**
     * @return PriorityTranslation[]|null
     */
    public function getTranslations() : ?array
    {
        return $this->translations;
    }
    /**
     * @param PriorityTranslation[]|null $translations
     * @return self
     */
    public function setTranslations(?array $translations) : self
    {
        $this->translations = $translations;
        return $this;
    }
}
