<?php

declare (strict_types=1);
namespace SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\Ticket;

use SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Annotation\SerializedName;
class SlaPlan extends \SupportPal\WhmcsIntegration\Vendor\SupportPal\ApiClient\Model\BaseModel
{
    /**
     * @var int
     * @SerializedName("id")
     */
    private $id;
    /**
     * @var int
     * @SerializedName("condition_group_type")
     */
    private $conditionGroupType;
    /**
     * @var string|null
     * @SerializedName("description")
     */
    private $description;
    /**
     * @var int
     * @SerializedName("created_at")
     */
    private $createdAt;
    /**
     * @var int|null
     * @SerializedName("order")
     */
    private $order;
    /**
     * @var int
     * @SerializedName("updated_at")
     */
    private $updatedAt;
    /**
     * @var int
     * @SerializedName("all_hours")
     */
    private $allHours;
    /**
     * @var string
     * @SerializedName("name")
     */
    private $name;
    /**
     * @var SlaPlanTranslation[]|null
     * @SerializedName("translations")
     */
    private $translations;
    /**
     * @return int
     */
    public function getId() : int
    {
        return $this->id;
    }
    /**
     * @param int $id
     * @return self
     */
    public function setId(int $id) : self
    {
        $this->id = $id;
        return $this;
    }
    /**
     * @return int
     */
    public function getConditionGroupType() : int
    {
        return $this->conditionGroupType;
    }
    /**
     * @param int $conditionGroupType
     * @return self
     */
    public function setConditionGroupType(int $conditionGroupType) : self
    {
        $this->conditionGroupType = $conditionGroupType;
        return $this;
    }
    /**
     * @return string|null
     */
    public function getDescription() : ?string
    {
        return $this->description;
    }
    /**
     * @param string|null $description
     * @return self
     */
    public function setDescription(?string $description) : self
    {
        $this->description = $description;
        return $this;
    }
    /**
     * @return int
     */
    public function getCreatedAt() : int
    {
        return $this->createdAt;
    }
    /**
     * @param int $createdAt
     * @return self
     */
    public function setCreatedAt(int $createdAt) : self
    {
        $this->createdAt = $createdAt;
        return $this;
    }
    /**
     * @return int|null
     */
    public function getOrder() : ?int
    {
        return $this->order;
    }
    /**
     * @param int|null $order
     * @return self
     */
    public function setOrder(?int $order) : self
    {
        $this->order = $order;
        return $this;
    }
    /**
     * @return int
     */
    public function getUpdatedAt() : int
    {
        return $this->updatedAt;
    }
    /**
     * @param int $updatedAt
     * @return self
     */
    public function setUpdatedAt(int $updatedAt) : self
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }
    /**
     * @return int
     */
    public function getAllHours() : int
    {
        return $this->allHours;
    }
    /**
     * @param int $allHours
     * @return self
     */
    public function setAllHours(int $allHours) : self
    {
        $this->allHours = $allHours;
        return $this;
    }
    /**
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->name = $name;
        return $this;
    }
    /**
     * @return SlaPlanTranslation[]|null
     */
    public function getTranslations() : ?array
    {
        return $this->translations;
    }
    /**
     * @param SlaPlanTranslation[]|null $translations
     * @return self
     */
    public function setTranslations(?array $translations) : self
    {
        $this->translations = $translations;
        return $this;
    }
}
