<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\RateLimiter;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Request;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\RateLimiter\RateLimit;
/**
 * A special type of limiter that deals with requests.
 *
 * This allows to limit on different types of information
 * from the requests.
 *
 * @author Wouter de Jong <wouter@wouterj.nl>
 */
interface RequestRateLimiterInterface
{
    public function consume(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Request $request) : \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\RateLimiter\RateLimit;
    public function reset(\SupportPal\WhmcsIntegration\Vendor\Symfony\Component\HttpFoundation\Request $request) : void;
}
