<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer;

use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\InvalidArgumentException;
use SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\LogicException;
/**
 * A normalizer that uses an objects own JsonSerializable implementation.
 *
 * @author Fred Cox <mcfedr@gmail.com>
 */
class JsonSerializableNormalizer extends \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\AbstractNormalizer
{
    /**
     * {@inheritdoc}
     */
    public function normalize($object, string $format = null, array $context = [])
    {
        if ($this->isCircularReference($object, $context)) {
            return $this->handleCircularReference($object, $format, $context);
        }
        if (!$object instanceof \JsonSerializable) {
            throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\InvalidArgumentException(\sprintf('The object must implement "%s".', \JsonSerializable::class));
        }
        if (!$this->serializer instanceof \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Normalizer\NormalizerInterface) {
            throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\LogicException('Cannot normalize object because injected serializer is not a normalizer.');
        }
        return $this->serializer->normalize($object->jsonSerialize(), $format, $context);
    }
    /**
     * {@inheritdoc}
     */
    public function supportsNormalization($data, string $format = null)
    {
        return $data instanceof \JsonSerializable;
    }
    /**
     * {@inheritdoc}
     */
    public function supportsDenormalization($data, string $type, string $format = null)
    {
        return \false;
    }
    /**
     * {@inheritdoc}
     */
    public function denormalize($data, string $type, string $format = null, array $context = [])
    {
        throw new \SupportPal\WhmcsIntegration\Vendor\Symfony\Component\Serializer\Exception\LogicException(\sprintf('Cannot denormalize with "%s".', \JsonSerializable::class));
    }
    /**
     * {@inheritdoc}
     */
    public function hasCacheableSupportsMethod() : bool
    {
        return __CLASS__ === static::class;
    }
}
