<link rel="stylesheet" type="text/css" media="screen" href="templates/supportpal/css/main.css" />
<link rel="stylesheet" type="text/css" media="screen" href="templates/supportpal/dist/submitticket.css" />

{if isset($submit_status) && $submit_status == 0}
    {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG.genericerror.title}
{/if}

<form id="submitticket" method="post" action="{$smarty.server.PHP_SELF}?step=2&deptid={$department.id|escape}&submit=1" enctype="multipart/form-data" role="form">

    <input type="hidden" name="deptid" value="{$department.id|escape}" />

    <div class="row">
        <div class="form-group col-sm-3">
            <label for="inputDepartment">{$LANG.supportticketsdepartment}</label>
            <select name="hidden_deptid" class="form-control" disabled="disabled">
                <option value="{$department.id|escape}" selected="selected">
                    {$department.name|escape}
                </option>
            </select>
        </div>
        <div class="form-group col-sm-3">
            <label for="inputPriority">{$LANG.supportticketsticketurgency}</label>
            <select name="urgency" id="inputPriority" class="form-control">
                {section name=priority loop=$priorities}
                    <option value="{$priorities[priority].id}" {if $priorities[priority].id eq $priority}selected="selected"{/if}>{$priorities[priority].name|escape}</option>
                {/section}
            </select>
        </div>
    </div>

    <div class="row form-group">
        <div class="col-sm-12">
            <label for="inputAttachments">{$LANG2.ticket_cc}</label>
        </div>
        <div class="col-sm-9">
            {if $cc}
                {foreach from=$cc item=email name=cc}
                    <input type="text" name="cc[]" value="{$email|escape}" class="form-control"
                           {if !$smarty.foreach.cc.first}style="margin-top: 8px;"{/if} />
                {/foreach}
            {else}
                <input type="text" name="cc[]" class="form-control" />
            {/if}
            <div id="ccContainer"></div>
        </div>
        <div class="col-sm-3">
            <button type="button" class="btn btn-default btn-block" id="sp-extra-cc">
                <i class="fa fas fa-plus"></i> {$LANG.addmore}
            </button>
        </div>
    </div>

    <div class="row">
        <div class="form-group col-sm-10">
            <label for="inputSubject">{$LANG.supportticketsticketsubject}</label>
            <input type="text" name="subject" id="inputSubject" value="{$subject|escape}" class="form-control" />
        </div>
    </div>

    <div class="form-group">
        <label for="inputMessage">{$LANG.contactmessage}</label>
        <textarea name="message" id="inputMessage" rows="12" class="form-control">{$message|escape}</textarea>
    </div>

    <div class="row form-group">
        <div class="col-sm-12">
            <label for="inputAttachments">{$LANG.supportticketsticketattachments}</label>
        </div>
        <div class="col-sm-9">
            <input type="file" name="attachments[]" id="inputAttachments" class="form-control" />
            <div id="fileUploadsContainer"></div>
        </div>
        <div class="col-sm-3">
            <button id="sp-extra-attachment" type="button" class="btn btn-default btn-block">
                <i class="fa fas fa-plus"></i> {$LANG.addmore}
            </button>
        </div>
        <div class="col-sm-12 ticket-attachments-message text-muted">
            {$LANG.supportticketsallowedextensions}: {$settings.allowed_files|replace:'|':', '|escape}
        </div>
    </div>

    {if $customfields|@count > 0}
        {include file='templates/supportpal/customfields.tpl'}
    {/if}

    <div id="autoAnswerSuggestions" class="well card hidden d-none" style="margin-top: 1rem" data-is-enabled="{$article_suggestions|escape}">
        <div class="card-body">
            <h3 class="card-title">{$LANG.kbsuggestions}</h3>

            <p>{$LANG.kbsuggestionsexplanation}</p>

            <div class="sp-articles">
                {foreach from=$kbarticles item=kbarticle}
                    <p>
                        <a href="knowledgebase.php?id={$kbarticle.id|escape}" target="_blank">
                            <span class="glyphicon glyphicon-file"></span>
                            {$kbarticle.title|escape}
                        </a> - {$kbarticle.article|escape}...
                    </p>
                {/foreach}
            </div>
        </div>
    </div>

    {if isset($submit_status) && $submit_status == -1}
        <br />
        {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG2.tickets_captchaError}
    {/if}
    {if isset($upload_error) && $upload_error == 1}
        <br />
        {include file="$template/includes/alert.tpl" type="danger" textcenter=true hide=false msg=$LANG2.tickets_uploads_error}
    {/if}

    {include file='templates/supportpal/recaptcha.tpl'}

    <br />

    <input type="submit" value="{$LANG.supportticketsticketsubmit}" class="btn btn-primary" />

</form>
